###############################################################################
# exampleClient.R
# 2007 05 08 : GF
###############################################################################
# call this in R as:
# > source ("exampleClient.R")
# > client(1234, "myhost")
# Enter text to send to socket or 'quit' to close: <type your message here!>
##################################################


client <- function(port, hostString){
  cat("Enter text to send to socket or \'quit\' to close: ")
  outgoing <- readLines(,1)     
  sendReceive(port, hostString, outgoing) 
  if (outgoing != "quit"){
     client(port, hostString)
  }
}

sendReceive <- function(port, hostString, msg) {
    sok<-socketConnection(hostString, port,server=F,blocking=T)
    sendReceiveHelper(msg, sok)
    close(sok)
    cat("Socket closed.\n")
}

sendReceiveHelper <- function(msg, sok, waitForReply){
    cat(paste("Client sending: \"", msg, "\"\n",sep="")) 
    writeLines(msg,sok)
    incoming<-readLines(sok,1)
    cat(paste("Client received: \"", incoming, "\"\n",sep=""))
    return(incoming)
}

###############################################################################
