###############################################################################
# exampleServer.R
# 2007 05 08 : GF
###############################################################################
# call this in R as:
# > source ("exampleServer.R")
# > server(1234, "myhost")

server<- function(port, hostString){
    reply<-sendReceive(port, hostString)
    if (reply !="quit") {
	server(port, hostString)
    }
}	

sendReceive <- function(port, hostString) {
    sok<-socketConnection(hostString, port,server=T,blocking=T)
    res<-sendReceiveHelper(sok)
    close(sok)
    cat("Socket closed.\n")
    return(res)
}

sendReceiveHelper <- function(sok){
    incoming<-readLines(sok,1)
    if (incoming != "quit"){
    	outgoing<-paste("ACK:",incoming)
    	cat(paste("Server received: \"", incoming, "\"\n",sep=""))
    	cat(paste("Server sending: \"", outgoing, "\"\n",sep="")) 
    	writeLines(outgoing,sok)
    }
    return(incoming)
}

###############################################################################
